/*
 * File: wr_version.js
 *
 * Copyright (c) 2007-2008, Paulo Avila (apaulodesign.com)
 *
 * Project: General Widget Resource
 *
 * Description: Acquires the version of the widget from an online
 * PHP application through AJAX. This value is passed to an externally
 * defined function that actually does something with it.
 *
 * NOTE THAT THIS RESOURCE DEPENDS ON THE wr_plist.js RESOURCE.
 *
 * NOTE THAT THREE FUNCTIONS SPECIFIC TO A WIDGET MUST BE CREATED ELSEWHERE:
 *  - w_versionQuery_startVisual()
 *  - w_versionQuery_stopVisual()
 *  - w_versionQuery_response(latestVersion)
 *
 * Modification Log:
 *	2007.06.03	Paulo	- Initial setup of functions
 *	2008.03.02	Paulo	- Modularized code so that it can be used for different widgets
 *	2008.03.03	Paulo	- Dynamically gets the widget name by use of the wr_plist.js resource
 *	2008.03.15	Paulo	- Added the wr_getExtension() function to parse the CFBundleIdentifier value
 *	2008.09.12	Paulo	- Skeleton functions for response code errors...
 *	2008.09.14	Paulo	- Moved the wr_getExtension() function to the wr_basic.js resource
 */

var AJAX_STATE_UNSENT = 0;
var AJAX_STATE_OPEN = 1;
var AJAX_STATE_HEADERS_RECEIVED = 2;
var AJAX_STATE_LOADING = 3;
var AJAX_STATE_DONE = 4;

var RESPONSE_CODE_OK = 200;
var RESPONSE_CODE_NOT_FOUND = 404;

var g_ajaxRequest = null;


/*
 * Initiates an asynchronous AJAX request to an online PHP application.
 *
 * The url for the PHP application must be defined globally in <VERSION_CHECK_APP>.
 *
 * When the request completes, the externally defined w_versionQuery_response(latestVersion) function
 * is called to act on the response.
 *
 * This function also calls the w_versionQuery_startVisual() and w_versionQuery_stopVisual()
 * functions that reflect the status of the request - such as a spinner animation
 * or some other sort of visual indicator.
 */
function wr_versionQuery()
{
	var url = VERSION_CHECK_APP + "?widget=" + wr_getExtension(wr_getPlistValue("CFBundleIdentifier"));

	g_ajaxRequest = new XMLHttpRequest();

	g_ajaxRequest.open("GET", url);
	g_ajaxRequest.setRequestHeader("Cache-Control", "no-cache");
	g_ajaxRequest.onreadystatechange = function () {
		if (g_ajaxRequest.readyState == AJAX_STATE_DONE)
		{
			w_versionQuery_stopVisual();	// customizable function particular to the widget

			if (g_ajaxRequest.status == RESPONSE_CODE_OK)
				w_versionQuery_response(g_ajaxRequest.responseText);	// customizable function particular to the widget
			/*
			else if (g_ajaxRequest.status == 0)
				wr_alert("check ur internet connection or try again later");
			else
				wr_alert("my site might be down temporarily (RESPONSE_CODE_NOT_FOUND) (404)");
			*/
		}
		/*
		else if (g_ajaxRequest.readyState == AJAX_STATE_LOADING)
		{
			//warning message if a reasonable timeout is reached
			//allow for abort with the use of request g_ajaxRequest.abort();
		}
		*/
	};

	g_ajaxRequest.send(null);		// sends the request
	w_versionQuery_startVisual();		// customizable function particular to the widget
}
