/*
 * File: wr_plist.js
 *
 * Copyright (c) 2008, Paulo Avila (apaulodesign.com)
 *
 * Project: General Widget Resource
 *
 * Description: Provides read access to the values of keys defined inside the
 * Info.plist file by the use of AJAX and XML parsing.
 *
 * Modification Log:
 *	2008.03.03	Paulo	- Initial skeleton structure setup (not functional)
 *	2008.03.05	Paulo	- Finalized functionality
 *	2008.03.15	Paulo	- Updated comments and code structure
 */

var ELEMENT_NODE = 1;
var ATTRIBUTE_NODE = 2;
var TEXT_NODE = 3;
var CDATA_SECTION_NODE = 4;
var ENTITY_REFERENCE_NODE = 5;
var ENTITY_NODE = 6;
var PROCESSING_INSTRUCTION_NODE = 7;
var COMMENT_NODE = 8;
var DOCUMENT_NODE = 9;
var DOCUMENT_TYPE_NODE = 10;
var DOCUMENT_FRAGMENT_NODE = 11;
var NOTATION_NODE = 12;


/*
 * Returns the value of the <key> contained in the Info.plist file.
 * If the value is an array, it will return a comma-delimeted
 * string containing all the values of the array.
 *
 * Note that the Info.plist file must exist in the same directory as
 * the HTML file that calls this function. Ideally this location is
 * the root of the widget.
 */
function wr_getPlistValue(key)
{
	var i, j;
	var keyValue = "";			// the value that will be returned

	var nodes = null;			// will contain all the nodes of the Info.plist file
	var arrayNodes = null;		// only used if the target <key> is an array of values

	var ajaxRequest = new XMLHttpRequest();

	// synchronous ajax request to get the contents of the Info.plist file
	ajaxRequest.open("GET", window.location.pathname.replace(/[^/]*$/, "Info.plist"), false);
	ajaxRequest.send(null);

	nodes = ajaxRequest.responseXML.getElementsByTagName("dict")[0].childNodes;

	// traverse the file until the requested key has been found
	for (i = 0; i < nodes.length; i++)
	{
		if (nodes[i].nodeType == ELEMENT_NODE &&
			nodes[i].tagName.toLowerCase() == "key" &&
			nodes[i].firstChild.data == key)
		{
			if (nodes[i+2].tagName.toLowerCase() != "array")
			{
				keyValue = nodes[i+2].firstChild.data;
			}
			else
			{
				keyValue = new Array();
				arrayNodes = nodes[i+2].childNodes;

				for (j = 0; j < arrayNodes.length; j++)
				{
					if (arrayNodes[j].nodeType == ELEMENT_NODE)
						keyValue.push(arrayNodes[j].firstChild.data);
				}
			}

			break;
		}
	}

	return keyValue;
}
