/*
 * File: wr_basic.js
 *
 * Copyright (c) 2007-2008, Paulo Avila (apaulodesign.com)
 *
 * Project: General Widget Resource
 *
 * Description: Provides the necessary functions for the basic operation of
 * most widgets.
 *
 * Modification Log:
 *	2007.01.22	Paulo	- Initial setup with the wr_showBack() and wr_showFront() functions
 *	2007.05.29	Paulo	- Added the wr_getLocalizedString() function
 *	2007.09.09	Paulo	- Added the wr_getSavedPreference() function
 *	2008.09.13	Paulo	- Added the wr_setPreference() function
 *	2008.09.14	Paulo	- Added the wr_widgetHandlers(), wr_getExtension() and wr_openURL() functions
 */


/*
 * Registers Widget/Dashboard Events to their respective handlers
 *
 * identifier - (READ ONLY) contains a unique identifier that is assigned by Dashboard and persists between each instantiation
 * onshow - Dashboard environment is activated
 * ohhide - Dashboard environment is exited
 * onremove - Widget instance is closed (not refreshed)
 * onfocus - Widget instance gets key focus
 * onblur - Widget instance looses key focus
 * ondragstart - Widget is being dragged
 * ondragend - Widget just finshed being dragged
 */
function wr_widgetHandlers()
{
	if (window.widget)
	{
		//widget.identifier;
		//widget.onshow = w_dashboardActivatedHandler;
		//widget.onhide = w_dashboardHiddenHandler;
		widget.onremove = w_widgetRemovedHandler;
//		widget.onremove = function () { w_stopSaverEngine(); }
		//widget.onfocus = w_widgetFocusedHandler;
		//widget.onblur = w_widgetBlurredHandler;
		//widget.ondragstart = w_widgetDragStartHandler;
		//widget.ondragend = w_widgetDragEndHandler;
	}
}


/*
 * Called when the information button (ibutton) is clicked.
 * Performs the following operations:
 *
 *  - freezes the widget (so it can be changed without the user noticing)
 *  - hides the front
 *  - shows the back
 *  - flips the widget over (animation provided by system)
 */
function wr_showBack()
{
	// freeze the widget and prepare to show the back
	if (window.widget)
		widget.prepareForTransition("ToBack");

	document.getElementById("front").style.display="none";
	document.getElementById("back").style.display="block";

	// flip it over
	if (window.widget)
		setTimeout ('widget.performTransition();', 0);
}


/*
 * Called when the Done button on the back is clicked.
 * Performs the following operations:
 *
 *  - freezes the widget (so it can be changed without the user noticing)
 *  - hides the back
 *  - shows the front
 *  - flips the widget over (animation provided by system)
 */
function wr_showFront()
{
	// freeze the widget and prepare to show the front
	if (window.widget)
		widget.prepareForTransition("ToFront");

	document.getElementById("back").style.display="none";
	document.getElementById("front").style.display="block";

	// flip it over
	if (window.widget)
		setTimeout ('widget.performTransition();', 0);
}


/*
 * Returns the localized equivalent of <key>.
 * If a localization doesn't exist, the function simply returns what was passed to it.
 */
function wr_getLocalizedString(key)
{
	var localizedText;

	if ( (localizedText = localizedStrings[key]) === undefined )
			localizedText = key;

	return localizedText;
/*
	try {
		key = localizedStrings[key] || key;
	}
	catch (e) {}

	return string;
*/
}


/*
 * Returns a previously saved preference with key <keyName>
 * or null if the <keyName> doesn't exist.
 */
function wr_getPreference(keyName)
{
	var keyValue = null;

	if (window.widget)
		keyValue = widget.preferenceForKey(keyName);

	return keyValue;
}


/*
 * Saves a value (<keyValue>) to a corresponding key (<keyName>).
 * Returns 'undefined' on success and the value to be saved otherwise.
 */
function wr_setPreference(keyValue, keyName)
{
	if (window.widget)
		keyValue = widget.setPreferenceForKey(keyValue, keyName);

	return keyValue;
}


/*
 * Opens an external URL followed by GET data items.
 *
 * If no parameters are specifed, this function opens the <EXTERNAL_URL>
 * along with GET data about the widget name and version.
 *
 * If parameters are specified, the first must be the URL and everything
 * else will be appended as GET data items in the following format:
 * <param0>?arg1=<param1>&arg2=<param2>&arg3=<param3>...
 */
function wr_openURL()
{
	var i;
	var url;
	var source;
	var version;

	// special 'default' condition that will open the <EXTERNAL_URL>
	// along with GET data about the widget name and version.
	if (arguments.length == 0)
	{
		source = wr_getExtension(wr_getPlistValue("CFBundleIdentifier"));
		version = wr_getPlistValue("CFBundleVersion");

		url = EXTERNAL_URL + "?source=" + source + "&version=" + version;
	}
	else
	{
		url = arguments[0];

		// add any GET data that was passed as parameters
		if (arguments.length > 1)
			for (i = 1; i < arguments.length; i++)
				url += ((i == 1) ? "?arg" : "&arg") + i + "=" + encodeURI(arguments[i]);
	}

	if (window.widget)
		widget.openURL(url);
	else
		window.location.href = url;
}


/*
 * Returns the text after the last period ('.') contained within a <string>.
 * If the <string> does not contain a period, simply returns the original <string>.
 */
function wr_getExtension(string)
{
	for (var i = string.length - 1; i > 0; i--)
		if (string.charAt(i-1) == '.')
			break;

	return string.substr(i, string.length - i);
}
